/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;

public class PropertyAssociation
extends PropertyXRef {
    PropertyAssociation(String tag) {
        super(tag);
        this.assertTag("ASSO");
    }

    public Entity getWitness() {
        return this.isGrammar7() ? (Entity)this.getTargetEntity().orElse(null) : this.getEntity();
    }

    public Entity getBeneficiary() {
        return this.isGrammar7() ? this.getEntity() : (Entity)this.getTargetEntity().orElse(null);
    }

    public String getRole() {
        String ret = "";
        Property role = this.getProperty(this.isGrammar7() ? "ROLE" : "RELA");
        if (role != null) {
            ret = role instanceof PropertyChoiceRole ? ((PropertyChoiceRole)role).getPhraseDisplayValue() : role.getDisplayValue();
        }
        return ret;
    }

    public Property getEvent(boolean force) {
        Property event;
        Property targetParent = this.getTarget() == null ? null : this.getTarget().getParent();
        Property property = event = this.isGrammar7() ? this.getParent() : targetParent;
        return event instanceof Indi || event instanceof Fam ? (force ? event : null) : event;
    }

    public String getEventDate(Property event) {
        String ret = "";
        Property date = event.getProperty("DATE");
        if (date != null) {
            ret = date.getDisplayValue().trim();
        }
        return ret.isEmpty() ? resources.getString("prop.asso.unknown") : ret;
    }

    public String getEventPlace(boolean fullDisplay, Property event) {
        String ret = "";
        Property place = event.getProperty("PLAC");
        if (place != null) {
            if (fullDisplay) {
                ret = place.getDisplayValue().trim();
            } else {
                PropertyPlace pPlace = (PropertyPlace)place;
                ret = pPlace.getCity().trim();
            }
        }
        return ret.isEmpty() ? resources.getString("prop.asso.unknown") : ret;
    }

    private String getName(Entity entity) {
        String name = "";
        if (entity == null) {
            return super.getValue().equals("@VOID@") ? "VOID" : "";
        }
        return entity.getDisplayTitle(false);
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(false);
    }

    public String getDisplayValue(boolean fullDisplay) {
        String ret = "";
        String witnessName = this.getName(this.getWitness());
        Object role = this.getRole();
        role = ((String)role).isEmpty() ? resources.getString("prop.asso.unknownrole") : (String)role + " " + resources.getString("prop.asso.iswitnessOFsomeone");
        String beneficiaryName = this.getName(this.getBeneficiary());
        Property event = this.getEvent(false);
        if (event != null) {
            Object eventName = event.getPropertyName();
            if (event.getTag().equals("EVEN") || event.getTag().equals("FACT")) {
                String type;
                String desc = event.getDisplayValue();
                if (!desc.trim().isEmpty()) {
                    eventName = desc;
                }
                if (!(type = event.getPropertyValue("TYPE")).trim().isEmpty()) {
                    eventName = (String)eventName + " (" + type + ")";
                }
            }
            String date = this.getEventDate(event);
            String place = this.getEventPlace(fullDisplay, event);
            ret = resources.getString("prop.asso.displaywithevent", witnessName, role, beneficiaryName, eventName, date, place);
        } else {
            ret = resources.getString("prop.asso.displaywithoutevent", witnessName, role, beneficiaryName);
        }
        return ret;
    }

    @Override
    protected String getForeignDisplayValue() {
        return this.getPropertyName() + ": " + this.getDisplayValue(false);
    }

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.asso.veto");
    }

    @Override
    public void link() throws GedcomException {
        Entity ent = this.getCandidate();
        PropertyForeignXRef fxref = new PropertyForeignXRef();
        if (!this.isGrammar7()) {
            try {
                PropertyRelationship rela = (PropertyRelationship)this.getProperty("RELA");
                ent.getProperty(rela.getAnchor()).addProperty(fxref);
            }
            catch (Throwable t) {
                ent.addProperty(fxref);
            }
            if ("5.5".equals(this.getGedcom().getGrammar())) {
                Property type = this.getProperty("TYPE");
                if (type == null) {
                    type = this.addProperty(new PropertySimpleValue("TYPE"));
                }
                type.setValue(ent.getTag());
            }
        } else {
            ent.addProperty(fxref);
        }
        this.link(fxref);
    }

    @Override
    public String getTargetType() {
        String[] entities;
        if (this.isGrammar7()) {
            return "INDI";
        }
        if (!this.getMetaProperty().allows("TYPE") && "5.5".equals(this.getGedcom().getGrammar())) {
            return "INDI";
        }
        Property type = this.getProperty("TYPE");
        if (type != null) {
            return type.getValue();
        }
        String prefix = this.getValue().substring(1, 2);
        for (String entitie : entities = this.getGedcom().getEntitiesType()) {
            if (!Gedcom.getEntityPrefix(entitie).startsWith(prefix)) continue;
            return entitie;
        }
        return "INDI";
    }
}

