/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.util.EnvironmentChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Logger;

public class CachingStreamHandler
extends URLStreamHandler {
    private static final long EXPIRE_MILLIS = 86400000L;
    private static final Logger LOG = Logger.getLogger("ancestris.io");
    private File cache;

    public CachingStreamHandler(String name) {
        this.cache = new File(EnvironmentChecker.getProperty("user.home.ancestris", null, "local cache home"), name);
        if (!this.cache.isDirectory() && !this.cache.mkdir()) {
            LOG.warning("caching disable - can't write to " + this.cache);
            this.cache = null;
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    protected File getCacheEntry(URL url) {
        String host = url.getHost();
        String file = url.getFile();
        String dir = "";
        int d = file.lastIndexOf(47);
        if (d > 0) {
            dir = file.substring(0, d);
            file = file.substring(d + 1);
        }
        Object hash = "";
        int q = file.indexOf(63);
        if (q > 0) {
            hash = "-" + Integer.toString(Math.abs(file.substring(q).hashCode()));
            file = file.substring(0, q);
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        String ext = "";
        int e = file.lastIndexOf(46);
        if (e >= 0) {
            ext = file.substring(e);
            file = file.substring(0, e);
        }
        return new File(this.cache, host + "/" + dir + "/" + file + (String)hash + ext);
    }

    private class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (CachingStreamHandler.this.cache != null) {
                URL url = this.getURL();
                File cached = CachingStreamHandler.this.getCacheEntry(url);
                if (cached.exists() && cached.lastModified() > System.currentTimeMillis() - 86400000L) {
                    LOG.fine("Using cached copy of wiki file " + this.getURL());
                    return new FileInputStream(cached);
                }
                return new CachingInputStream(this.getURL(), cached);
            }
            return this.getURL().openStream();
        }
    }

    private class CachingInputStream
    extends InputStream {
        private URL url;
        private File tmp;
        private File cached;
        private int len;
        private URLConnection con;
        private OutputStream out;
        private InputStream in;

        private CachingInputStream(URL url, File cached) throws IOException {
            this.url = new URL(url.toString());
            this.cached = cached;
        }

        private void open() throws IOException {
            if (this.in != null) {
                return;
            }
            try {
                this.con = this.url.openConnection();
                this.in = this.con.getInputStream();
            }
            catch (IOException e) {
                if (this.cached.exists()) {
                    LOG.fine("Falling back to cached copy of wiki file " + this.url);
                    this.in = new FileInputStream(this.cached);
                    this.con = null;
                    return;
                }
                throw e;
            }
            try {
                this.tmp = new File(this.cached.getAbsolutePath() + ".tmp");
                this.tmp.getParentFile().mkdirs();
                this.out = new FileOutputStream(this.tmp);
            }
            catch (IOException e) {
                LOG.fine("can't write cached copy of wiki file " + this.url);
            }
        }

        @Override
        public int read() throws IOException {
            this.open();
            int i = this.in.read();
            if (this.out != null) {
                this.out.write(i);
            }
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.open();
            int i = this.in.read(b);
            if (i > 0 && this.out != null) {
                this.out.write(b, 0, i);
            }
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.open();
            int i = this.in.read(b, off, len);
            if (i > 0 && this.out != null) {
                this.out.write(b, off, i);
            }
            return i;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                if (this.con != null) {
                    if (this.tmp.length() == (long)this.con.getContentLength()) {
                        this.tmp.renameTo(this.cached);
                    } else {
                        LOG.fine("not caching " + this.tmp.length() + " copy of " + this.con.getContentLength() + " wiki file " + CachingStreamHandler.this.cache);
                    }
                }
                this.tmp.delete();
            }
            if (this.in != null) {
                this.in.close();
            }
        }
    }
}

