/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.modules.gedcom.history.EntityHistory;
import ancestris.modules.gedcom.history.GedcomHistoryPlugin;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.xml.bind.annotation.XmlRootElement;
import org.openide.util.ChangeSupport;

@XmlRootElement(name="GedcomHistory", namespace="ancestris.modules.gedcom.history")
public class GedcomHistory
implements GedcomListener {
    private static final Logger log = Logger.getLogger(GedcomHistoryPlugin.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String gedcomName = "";
    private ArrayList<EntityHistory> historyList = null;

    public GedcomHistory() {
    }

    public GedcomHistory(String gedcomName) {
        this.gedcomName = gedcomName;
        this.historyList = new ArrayList();
    }

    public void clear() {
        this.historyList.clear();
    }

    public String getGedcomName() {
        return this.gedcomName;
    }

    public ArrayList<EntityHistory> getHistoryList() {
        return this.historyList;
    }

    public void setGedcomName(String gedcomName) {
        this.gedcomName = gedcomName;
    }

    public void setHistoryList(ArrayList<EntityHistory> historyList) {
        this.historyList = historyList;
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        log.log(Level.FINER, "Entity {0} id {1} added", new Object[]{entity.getTag(), entity.getId()});
        this.historyList.add(new EntityHistory("Created", entity, (Property)entity, "", ""));
        this.fireChange();
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        log.log(Level.FINER, "Entity {0} id {1} deleted", new Object[]{entity.getTag(), entity.getId()});
        this.historyList.add(new EntityHistory("Deleted", entity, (Property)entity, "", ""));
        this.fireChange();
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        log.log(Level.FINER, "Entity {0} id {1} Property {2} changed", new Object[]{property.getEntity().getTag(), property.getEntity().getId(), property.getTag()});
        if (!(property instanceof PropertyChange)) {
            this.historyList.add(new EntityHistory("Updated", property.getEntity(), property, "", property.getValue()));
            this.fireChange();
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        log.log(Level.FINER, "Entity {0} id {1} Property {2} added", new Object[]{property.getEntity().getTag(), added.getEntity().getId(), added.getTag()});
        if (!(property instanceof PropertyChange)) {
            this.historyList.add(new EntityHistory("Created", property.getEntity(), added, "", added.getValue()));
            this.fireChange();
        }
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        log.log(Level.FINER, "Entity {0} id {1} Property  {2} removed", new Object[]{property.getEntity().getTag(), property.getEntity().getId(), deleted.getTag()});
        if (!(property instanceof PropertyChange)) {
            this.historyList.add(new EntityHistory("Deleted", property.getEntity(), deleted, deleted.getValue(), ""));
            this.fireChange();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }
}

