/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.view.ExplorerHelper;
import ancestris.view.SelectionDispatcher;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.ChooseBlueprintAction;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.Node;

public class XRefBean
extends PropertyBean
implements AncestrisActionProvider {
    private PropertyBean.Preview preview = new PropertyBean.Preview();
    private PropertyXRef xref;

    public XRefBean() {
        new ExplorerHelper((Component)this.preview).setPopupAllowed(true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.preview);
        this.preview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getID() != 500) {
                    return;
                }
                if (e.getClickCount() < 2) {
                    return;
                }
                if (XRefBean.this.xref == null) {
                    return;
                }
                SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new ViewContext((Property)XRefBean.this.xref));
            }
        });
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        if (!hasFocus || this.xref == null || !this.xref.isValid()) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        final Entity entity = (Entity)this.xref.getTargetEntity().get();
        String tag = entity.getTag();
        Blueprint bp = BlueprintManager.getInstance().getBlueprint(tag, REGISTRY.get("blueprint.entity" + tag, ""));
        actions.add((Action)new ChooseBlueprintAction(entity, bp){

            protected void commit(Entity recipient, Blueprint blueprint) {
                PropertyBean.REGISTRY.put("blueprint.entity" + blueprint.getTag(), blueprint.getName());
                XRefBean.this.preview.setEntity(entity);
            }
        });
        return actions;
    }

    @Override
    protected void commitImpl(Property property) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setPropertyImpl(Property prop) {
        PropertyXRef xref;
        this.xref = xref = (PropertyXRef)prop;
        if (xref != null && xref.isValid()) {
            this.preview.setEntity(xref.getTargetEntity().orElse(null));
        } else {
            this.preview.setEntity(null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(64, 48);
    }
}

