/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.Exceptions;

public class ReleveFileAncestrisV1 {
    private static final String fileSignature = "ANCESTRISV1";
    private static final char fieldSeparator = ';';
    private static final int nbFields = 78;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidFile(File inputFile, StringBuilder sb) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(ReleveFileAncestrisV1.checkUtf8Bom(new FileInputStream(inputFile)), "UTF-8"));
            String[] fields = ReleveFileAncestrisV1.splitLine(br);
            if (fields == null) {
                sb.append("ANCESTRISV1 ").append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
                boolean bl = false;
                return bl;
            }
            br.close();
        }
        catch (Exception ex) {
            sb.append("ANCESTRISV1 ").append(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static InputStream checkUtf8Bom(InputStream is) throws IOException {
        byte[] utf8Bom = new byte[]{-17, -69, -65};
        PushbackInputStream pis = new PushbackInputStream(is, utf8Bom.length);
        byte[] bomRead = new byte[utf8Bom.length];
        if (pis.read(bomRead, 0, utf8Bom.length) == -1) {
            return is;
        }
        if (!Arrays.equals(bomRead, utf8Bom)) {
            pis.unread(bomRead);
        }
        return pis;
    }

    private static String[] splitLine(BufferedReader br) throws Exception {
        List<String> fieldList = FileManager.Line.splitCSV(br, ';');
        if (fieldList != null) {
            String[] fields = fieldList.toArray(new String[0]);
            if (fields.length == 78) {
                if (fields[0].equals(fileSignature)) {
                    return fields;
                }
                throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineBegin"), fileSignature, fields[0]));
            }
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.FieldNb"), fields.length, 78));
        }
        return null;
    }

    public static FileBuffer loadFile(File inputFile) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            fileBuffer = ReleveFileAncestrisV1.loadFile(ReleveFileAncestrisV1.checkUtf8Bom(new FileInputStream(inputFile)));
            return fileBuffer;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            fileBuffer.append(ex.toString()).append("\n");
            return fileBuffer;
        }
    }

    public static FileBuffer loadFile(InputStream inputStream) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            String[] fields;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int lineNumber = 0;
            while ((fields = ReleveFileAncestrisV1.splitLine(br)) != null) {
                try {
                    AbstractRecord record;
                    ++lineNumber;
                    if (fields[Field.eventType.ordinal()].equals("N")) {
                        record = new RecordBirth();
                        record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                        record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], "", fields[Field.indiBirthDate.ordinal()], "", "", "", "", "", "", "", "", fields[Field.indiComment.ordinal()]);
                        record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], "", "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], "");
                        record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], "", "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], "");
                        record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                        record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                        record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                        record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[Field.eventType.ordinal()].equals("M")) {
                        record = new RecordMarriage();
                        record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], "M", fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], "", "", "", "", "", fields[Field.indiComment.ordinal()]);
                        record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], "", "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                        record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], "", "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], "");
                        record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], "", "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], "");
                        record.setWife(fields[Field.wifeFirstName.ordinal()], fields[Field.wifeLastName.ordinal()], "F", fields[Field.wifeAge.ordinal()], fields[Field.wifeBirthDate.ordinal()], fields[Field.wifeBirthPlace.ordinal()], "", fields[Field.wifeOccupation.ordinal()], "", "", fields[Field.wifeComment.ordinal()]);
                        record.setWifeMarried(fields[Field.wifeMarriedFirstName.ordinal()], fields[Field.wifeMarriedLastName.ordinal()], fields[Field.wifeMarriedOccupation.ordinal()], "", "", fields[Field.wifeMarriedComment.ordinal()], fields[Field.wifeMarriedDead.ordinal()]);
                        record.setWifeFather(fields[Field.wifeFatherFirstName.ordinal()], fields[Field.wifeFatherLastName.ordinal()], fields[Field.wifeFatherOccupation.ordinal()], "", "", fields[Field.wifeFatherComment.ordinal()], fields[Field.wifeFatherDead.ordinal()], "");
                        record.setWifeMother(fields[Field.wifeMotherFirstName.ordinal()], fields[Field.wifeMotherLastName.ordinal()], fields[Field.wifeMotherOccupation.ordinal()], "", "", fields[Field.wifeMotherComment.ordinal()], fields[Field.wifeMotherDead.ordinal()], "");
                        record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                        record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                        record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                        record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[Field.eventType.ordinal()].equals("D")) {
                        record = new RecordDeath();
                        record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], "", "", "", "", "", fields[Field.indiComment.ordinal()]);
                        record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], "", "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                        record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], "", "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], "");
                        record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], "", "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], "");
                        record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                        record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                        record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                        record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[Field.eventType.ordinal()].equals("V")) {
                        record = new RecordMisc();
                        record.setFieldValue(AbstractRecord.FieldType.eventType, fields[Field.eventTypeName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.notary, fields[Field.notaryComment.ordinal()]);
                        record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], "", "", "", "", "", fields[Field.indiComment.ordinal()]);
                        record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], "", "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                        record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], "", "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], "");
                        record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], "", "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], "");
                        record.setWife(fields[Field.wifeFirstName.ordinal()], fields[Field.wifeLastName.ordinal()], fields[Field.wifeSex.ordinal()], fields[Field.wifeAge.ordinal()], fields[Field.wifeBirthDate.ordinal()], fields[Field.wifeBirthPlace.ordinal()], "", fields[Field.wifeOccupation.ordinal()], "", "", fields[Field.wifeComment.ordinal()]);
                        record.setWifeMarried(fields[Field.wifeMarriedFirstName.ordinal()], fields[Field.wifeMarriedLastName.ordinal()], fields[Field.wifeMarriedOccupation.ordinal()], "", "", fields[Field.wifeMarriedComment.ordinal()], fields[Field.wifeMarriedDead.ordinal()]);
                        record.setWifeFather(fields[Field.wifeFatherFirstName.ordinal()], fields[Field.wifeFatherLastName.ordinal()], fields[Field.wifeFatherOccupation.ordinal()], "", "", fields[Field.wifeFatherComment.ordinal()], fields[Field.wifeFatherDead.ordinal()], "");
                        record.setWifeMother(fields[Field.wifeMotherFirstName.ordinal()], fields[Field.wifeMotherLastName.ordinal()], fields[Field.wifeMotherOccupation.ordinal()], "", "", fields[Field.wifeMotherComment.ordinal()], fields[Field.wifeMotherDead.ordinal()], "");
                        record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                        record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                        record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                        record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownEventType")).append(" ");
                    fileBuffer.append(fields[Field.eventType.ordinal()]);
                    fileBuffer.append("\n");
                }
                catch (Exception e) {
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(e.toString()).append("\n");
                }
            }
            br.close();
        }
        catch (Exception e) {
            fileBuffer.append(e.toString()).append("\n");
        }
        return fileBuffer;
    }

    public static StringBuilder saveFile(RecordModel recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), "UTF-8");
            for (int index = 0; index < recordModel.getRowCount(); ++index) {
                FileManager.Line line = new FileManager.Line(';');
                AbstractRecord record = recordModel.getRecord(index);
                if (recordType != null && recordType != record.getType()) continue;
                try {
                    if (record instanceof RecordBirth) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("N", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendCsv(String.valueOf(index), new String[0]);
                    }
                    if (record instanceof RecordMarriage) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("M", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendCsv(String.valueOf(index), new String[0]);
                    } else if (record instanceof RecordDeath) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("D", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendCsv(String.valueOf(index), new String[0]);
                    } else if (record instanceof RecordMisc) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("V", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventType), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.notary), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendCsv(String.valueOf(index), new String[0]);
                    }
                    line.appendCsv("\n", new String[0]);
                    writer.write(line.toString());
                    continue;
                }
                catch (IOException e) {
                    sb.append("Line ").append(" ").append(e).append("\n");
                    sb.append("   ").append(line).append("\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            sb.append(e).append("\n");
        }
        return sb;
    }

    static enum Field {
        ancetris,
        nomCommune,
        codeCommune,
        nomDepartement,
        stateName,
        countryName,
        parish,
        eventType,
        eventTypeName,
        eventTypeTag,
        eventDate,
        cote,
        freeComment,
        notaryComment,
        indiLastName,
        indiFirstName,
        indiSex,
        indiBirthPlace,
        indiBirthDate,
        indiAge,
        indiOccupation,
        indiComment,
        indiMarriedLastName,
        indiMarriedFirstName,
        indiMarriedDead,
        indiMarriedOccupation,
        indiMarriedComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherDead,
        indiFatherOccupation,
        indiFatherComment,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherDead,
        indiMotherOccupation,
        indiMotherComment,
        wifeLastName,
        wifeFirstName,
        wifeSex,
        wifeBirthPlace,
        wifeBirthDate,
        wifeAge,
        wifeOccupation,
        wifeComment,
        wifeMarriedLastName,
        wifeMarriedFirstName,
        wifeMarriedDead,
        wifeMarriedOccupation,
        wifeMarriedComment,
        wifeFatherLastName,
        wifeFatherFirstName,
        wifeFatherDead,
        wifeFatherOccupation,
        wifeFatherComment,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherDead,
        wifeMotherOccupation,
        wifeMotherComment,
        witness1LastName,
        witness1FirstName,
        witness1Occupation,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Occupation,
        witness2Comment,
        witness3LastName,
        witness3FirstName,
        witness3Occupation,
        witness3Comment,
        witness4LastName,
        witness4FirstName,
        witness4Occupation,
        witness4Comment,
        generalComment,
        recordNo;

    }
}

