/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    public static final String ZOOM_LEVEL_CHANGED_PROPERTY = "zoomLevel";
    public static final String ZOOM_INCREMENT_CHANGED_PROPERTY = "zoomIncrement";
    public static final String IMAGE_CHANGED_PROPERTY = "image";
    private double zoomIncrement = 0.2;
    private double zoomFactor = 1.0 + this.zoomIncrement;
    private BufferedImage image;
    private double initialScale = 0.0;
    private double scale = 0.0;
    private int originX = 0;
    private int originY = 0;
    private Point previousMousePosition;
    private Dimension previousPanelSize;
    private WheelZoomDevice wheelZoomDevice = null;
    MouseMode mouseMode = MouseMode.MOVE;
    private int areaSrcx;
    private int areaSrcy;
    private int areaDestx;
    private int areaDesty;
    private BasicStroke areaStroke;
    private GradientPaint areaGradient;
    private BufferedImage adjustImage = null;
    private int adjustX;
    private int adjustY;

    public ImagePanel() {
        this.setOpaque(false);
        this.areaGradient = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.white, true);
        this.areaStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 0.0f}, 0.0f);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ImagePanel.this.scale > 0.0) {
                    if (ImagePanel.this.isFullImageInPanel()) {
                        ImagePanel.this.centerImage();
                    } else if (ImagePanel.this.isImageEdgeInPanel()) {
                        ImagePanel.this.scaleOrigin();
                    }
                    ImagePanel.this.repaint();
                }
                ImagePanel.this.previousPanelSize = ImagePanel.this.getSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (ImagePanel.this.mouseMode == MouseMode.SELECT && SwingUtilities.isLeftMouseButton(e)) {
                    ImagePanel.this.adjustStart(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) && ImagePanel.this.mouseMode != MouseMode.MOVE) {
                    ImagePanel.this.adjustEnd();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (ImagePanel.this.mouseMode == MouseMode.MOVE) {
                        ImagePanel.this.moveImage(e.getPoint());
                    } else {
                        ImagePanel.this.adjustMove(e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ImagePanel.this.mouseMode == MouseMode.MOVE) {
                    ImagePanel.this.previousMousePosition = e.getPoint();
                }
            }
        });
        this.wheelZoomDevice = new WheelZoomDevice();
        this.addMouseWheelListener(this.wheelZoomDevice);
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void showImage(BufferedImage newImage) {
        this.image = newImage;
        this.adjustImage = null;
        this.areaDesty = 0;
        this.areaDestx = 0;
        this.areaSrcy = 0;
        this.areaSrcx = 0;
        this.repaint();
    }

    public void adjustAreaColor() {
        if (this.image != null) {
            if (this.mouseMode == MouseMode.SELECT) {
                this.mouseMode = MouseMode.MOVE;
                this.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.adjustImage = null;
                this.mouseMode = MouseMode.SELECT;
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToLeft() {
        if (this.image != null) {
            this.originX = 0;
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToRight() {
        if (this.image != null) {
            this.originX = this.getWidth() - this.getScreenImageWidth();
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToTop() {
        if (this.image != null) {
            this.originY = 0;
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToBottom() {
        if (this.image != null) {
            this.originY = this.getHeight() - this.getScreenImageHeight();
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean isleftSideVisible() {
        return this.originX >= 0;
    }

    public boolean isRightSideVisible() {
        if (this.image != null) {
            return this.originX + this.getScreenImageWidth() <= this.getWidth();
        }
        return true;
    }

    public boolean isTopSideVisible() {
        return this.originY >= 0;
    }

    public boolean isBottomSideVisible() {
        if (this.image != null) {
            return this.originY + this.getScreenImageHeight() <= this.getHeight();
        }
        return true;
    }

    private Coords panelToImageCoords(Point p) {
        return new Coords((double)(p.x - this.originX) / this.scale, (double)(p.y - this.originY) / this.scale);
    }

    private Coords imageToPanelCoords(Coords p) {
        return new Coords(p.x * this.scale + (double)this.originX, p.y * this.scale + (double)this.originY);
    }

    private boolean isImageEdgeInPanel() {
        if (this.previousPanelSize == null) {
            return false;
        }
        return this.originX > 0 && this.originX < this.previousPanelSize.width || this.originY > 0 && this.originY < this.previousPanelSize.height;
    }

    private boolean isFullImageInPanel() {
        return this.originX >= 0 && this.originX + this.getScreenImageWidth() < this.getWidth() && this.originY >= 0 && this.originY + this.getScreenImageHeight() < this.getHeight();
    }

    private void scaleOrigin() {
        this.originX = this.originX * this.getWidth() / this.previousPanelSize.width;
        this.originY = this.originY * this.getHeight() / this.previousPanelSize.height;
        this.repaint();
    }

    private double zoomToScale(double zoom) {
        return this.initialScale * zoom;
    }

    public double getZoom() {
        return this.scale / this.initialScale;
    }

    public void setZoom(double newZoom, Point zoomingCenter) {
        if (this.image != null) {
            Coords imageP = this.panelToImageCoords(zoomingCenter);
            if (imageP.x < 0.0) {
                imageP.x = 0.0;
            }
            if (imageP.y < 0.0) {
                imageP.y = 0.0;
            }
            if (imageP.x >= (double)this.image.getWidth()) {
                imageP.x = (double)this.image.getWidth() - 1.0;
            }
            if (imageP.y >= (double)this.image.getHeight()) {
                imageP.y = (double)this.image.getHeight() - 1.0;
            }
            Coords correctedP = this.imageToPanelCoords(imageP);
            this.scale = this.zoomToScale(newZoom);
            Coords panelP = this.imageToPanelCoords(imageP);
            this.originX += correctedP.getIntX() - (int)panelP.x;
            this.originY += correctedP.getIntY() - (int)panelP.y;
        }
        this.repaint();
    }

    private void centerImage() {
        this.originX = (this.getWidth() - this.getScreenImageWidth()) / 2;
        this.originY = (this.getHeight() - this.getScreenImageHeight()) / 2;
    }

    private void moveImage(Point newMousePosition) {
        int xDelta = newMousePosition.x - this.previousMousePosition.x;
        int yDelta = newMousePosition.y - this.previousMousePosition.y;
        this.originX += xDelta;
        if (this.adjustImage != null) {
            this.adjustX += xDelta;
        }
        this.originY += yDelta;
        if (this.adjustImage != null) {
            this.adjustY += yDelta;
        }
        this.previousMousePosition = newMousePosition;
        this.repaint();
    }

    private void adjustStart(int mouseX, int mouseY) {
        this.areaDestx = this.areaSrcx = mouseX;
        this.areaDesty = this.areaSrcy = mouseY;
        this.repaint();
    }

    private void adjustMove(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX < this.getWidth()) {
            this.areaDestx = mouseX;
        }
        if (mouseY >= 0 && mouseY < this.getHeight()) {
            this.areaDesty = mouseY;
        }
        this.repaint();
    }

    private void adjustEnd() {
        if (this.areaSrcx == this.areaDestx && this.areaSrcy == this.areaDesty) {
            return;
        }
        int x1 = this.areaSrcx < this.areaDestx ? this.areaSrcx : this.areaDestx;
        int y1 = this.areaSrcy < this.areaDesty ? this.areaSrcy : this.areaDesty;
        int x2 = this.areaSrcx > this.areaDestx ? this.areaSrcx : this.areaDestx;
        int y2 = this.areaSrcy > this.areaDesty ? this.areaSrcy : this.areaDesty;
        this.adjustX = x1;
        this.adjustY = y1;
        Coords point1 = this.panelToImageCoords(new Point(x1, y1));
        Coords point2 = this.panelToImageCoords(new Point(x2, y2));
        if (point1.x < 0.0) {
            this.adjustX = this.originX;
            point1.x = 0.0;
        }
        if (point1.y < 0.0) {
            this.adjustY = this.originY;
            point1.y = 0.0;
        }
        int width = (int)(point2.x - point1.x) + 1;
        int height = (int)(point2.y - point1.y) + 1;
        if (point1.x + (double)width > (double)this.image.getWidth()) {
            width = this.image.getWidth() - (int)point1.x;
        }
        if (point1.y + (double)height > (double)this.image.getHeight()) {
            height = this.image.getHeight() - (int)point1.y;
        }
        BufferedImage inputImage = null;
        try {
            inputImage = this.image.getSubimage((int)point1.x, (int)point1.y, width, height);
        }
        catch (Exception e) {
            return;
        }
        ColorConvertOp gray = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage grayImage = gray.filter(inputImage, null);
        int[] histogram = new int[256];
        byte[] pixels = (byte[])grayImage.getRaster().getDataElements(0, 0, width, height, null);
        for (int p = 0; p < width * height; ++p) {
            int n = pixels[p] & 0xFF;
            histogram[n] = histogram[n] + 1;
        }
        float lutScale = (float)(255.0 / (double)(width * height));
        byte[] lut = new byte[256];
        long sum = 0L;
        for (int i = 0; i < 256; ++i) {
            byte val = (byte)((float)(sum += (long)histogram[i]) * lutScale);
            lut[i] = val > 255 ? -1 : val;
        }
        ByteLookupTable table = new ByteLookupTable(0, lut);
        LookupOp lookupOp = new LookupOp(table, null);
        this.adjustImage = lookupOp.filter(grayImage, null);
        this.areaDesty = 0;
        this.areaDestx = 0;
        this.areaSrcy = 0;
        this.areaSrcx = 0;
        this.mouseMode = MouseMode.MOVE;
        this.setCursor(Cursor.getPredefinedCursor(13));
        System.out.println("ImagePanel MOVE_CURSOR");
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        if (this.scale == 0.0) {
            double xScale = (double)this.getWidth() / (double)this.image.getWidth();
            double yScale = (double)this.getHeight() / (double)this.image.getHeight();
            this.scale = this.initialScale = Math.min(xScale, yScale);
            this.centerImage();
        }
        g.drawImage(this.image, this.originX, this.originY, this.getScreenImageWidth(), this.getScreenImageHeight(), null);
        if (this.areaSrcx != this.areaDestx || this.areaSrcy != this.areaDesty) {
            int x1 = this.areaSrcx < this.areaDestx ? this.areaSrcx : this.areaDestx;
            int y1 = this.areaSrcy < this.areaDesty ? this.areaSrcy : this.areaDesty;
            int x2 = this.areaSrcx > this.areaDestx ? this.areaSrcx : this.areaDestx;
            int y2 = this.areaSrcy > this.areaDesty ? this.areaSrcy : this.areaDesty;
            Rectangle rectSelection = new Rectangle();
            rectSelection.x = x1;
            rectSelection.y = y1;
            rectSelection.width = x2 - x1 + 1;
            rectSelection.height = y2 - y1 + 1;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(new Color(0, 0, 255, 20));
            g2d.fill(rectSelection);
            g2d.setStroke(this.areaStroke);
            g2d.setPaint(this.areaGradient);
            g2d.draw(rectSelection);
        }
        if (this.adjustImage != null) {
            g.drawImage(this.adjustImage, this.adjustX, this.adjustY, (int)(this.scale * (double)this.adjustImage.getWidth()), (int)(this.scale * (double)this.adjustImage.getHeight()), null);
        }
    }

    private int getScreenImageWidth() {
        if (this.image != null) {
            return (int)(this.scale * (double)this.image.getWidth());
        }
        return 0;
    }

    private int getScreenImageHeight() {
        if (this.image != null) {
            return (int)(this.scale * (double)this.image.getHeight());
        }
        return 0;
    }

    private class WheelZoomDevice
    implements MouseWheelListener {
        private WheelZoomDevice() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Point p = e.getPoint();
            boolean zoomIn = e.getWheelRotation() < 0;
            ImagePanel.this.zoomFactor = zoomIn ? 1.0 + ImagePanel.this.zoomIncrement : 1.0 - ImagePanel.this.zoomIncrement;
            Coords imageP = ImagePanel.this.panelToImageCoords(ImagePanel.this.previousMousePosition);
            Coords adjustImageP = new Coords((double)(ImagePanel.this.previousMousePosition.x - ImagePanel.this.adjustX) / ImagePanel.this.scale, (double)(ImagePanel.this.previousMousePosition.y - ImagePanel.this.adjustY) / ImagePanel.this.scale);
            double oldZoom = ImagePanel.this.getZoom();
            ImagePanel.this.scale *= ImagePanel.this.zoomFactor;
            Coords panelP = ImagePanel.this.imageToPanelCoords(imageP);
            ImagePanel.this.originX += ImagePanel.this.previousMousePosition.x - (int)panelP.x;
            ImagePanel.this.originY += ImagePanel.this.previousMousePosition.y - (int)panelP.y;
            if (ImagePanel.this.adjustImage != null) {
                Coords ajustPanelP = new Coords(adjustImageP.x * ImagePanel.this.scale + (double)ImagePanel.this.adjustX, adjustImageP.y * ImagePanel.this.scale + (double)ImagePanel.this.adjustY);
                ImagePanel.this.adjustX += ImagePanel.this.previousMousePosition.x - (int)ajustPanelP.x;
                ImagePanel.this.adjustY += ImagePanel.this.previousMousePosition.y - (int)ajustPanelP.y;
            }
            ImagePanel.this.repaint();
        }
    }

    protected static enum MouseMode {
        MOVE,
        SELECT;

    }

    private class Coords {
        public double x;
        public double y;

        public Coords(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public int getIntX() {
            return (int)Math.round(this.x);
        }

        public int getIntY() {
            return (int)Math.round(this.y);
        }

        public String toString() {
            return "[Coords: x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

