/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.FieldSex;
import ancestris.modules.releve.model.RecordInfoPlace;
import ancestris.modules.releve.utils.CompareString;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openide.util.NbPreferences;

public class CompletionProvider {
    private final CompletionSet firstNames = new CompletionSet(CompletionType.firstName);
    private final CompletionSet lastNames = new CompletionSet(CompletionType.lastName);
    private final CompletionSet occupations = new CompletionSet(CompletionType.occupation);
    private final CompletionSet notaries = new CompletionSet(CompletionType.notary);
    private final CompletionSet places = new CompletionSet(CompletionType.place);
    private final CompletionSet eventTypes = new CompletionSet(CompletionType.eventType);
    private final HashMap<String, Integer> firstNameSex = new HashMap();
    private Locale locale = Locale.getDefault();
    private static final String ExcludedFirstNameList = "ExcludedFirstNameList";
    private static final String ExcludedLastNameList = "ExcludedLastNameList";
    private static final String ExcludedOccupationList = "ExcludedOccupationList";
    private static final String ExcludedPlaceList = "ExcludedPlaceList";

    public CompletionProvider() {
        AncestrisPlugin.register((Object)this);
    }

    protected void addRecord(AbstractRecord record) {
        this.eventTypes.add(record.getFieldValue(AbstractRecord.FieldType.eventType));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.indiFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), record.getFieldValue(AbstractRecord.FieldType.indiSex));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.indiSex)));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), "M");
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), "F");
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeSex));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.wifeSex)));
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), "M");
        this.addFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), "F");
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName));
        this.firstNames.add(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.indiLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.witness1LastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.witness2LastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.witness3LastName));
        this.lastNames.add(record.getFieldValue(AbstractRecord.FieldType.witness4LastName));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.indiOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation));
        this.occupations.add(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation));
        this.notaries.add(record.getFieldValue(AbstractRecord.FieldType.notary));
        if (!record.getFieldValue(AbstractRecord.FieldType.place).equals(RecordInfoPlace.EMPTY)) {
            this.places.add(record.getFieldValue(AbstractRecord.FieldType.place));
        }
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.indiResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.wifeResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence));
        this.places.add(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence));
    }

    protected void removeRecord(AbstractRecord record) {
        this.eventTypes.remove(record.getFieldValue(AbstractRecord.FieldType.eventType));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), record.getFieldValue(AbstractRecord.FieldType.indiSex));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.indiSex)));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), "M");
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), "F");
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeSex));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.wifeSex)));
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), "M");
        this.removeFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), "F");
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName));
        this.firstNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness1LastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness2LastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness3LastName));
        this.lastNames.remove(record.getFieldValue(AbstractRecord.FieldType.witness4LastName));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.indiOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation));
        this.occupations.remove(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation));
        this.notaries.remove(record.getFieldValue(AbstractRecord.FieldType.notary));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.indiResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.wifeResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence));
        this.places.remove(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence));
    }

    protected void removeAll() {
        this.firstNames.removeAll();
        this.lastNames.removeAll();
        this.occupations.removeAll();
        this.notaries.removeAll();
        this.places.removeAll();
        this.eventTypes.removeAll();
    }

    public void addFirstNameSex(String firstName, String sex) {
        if (firstName != null && !firstName.isEmpty() && sex != null) {
            int count;
            int n = count = this.firstNameSex.containsKey(firstName) ? this.firstNameSex.get(firstName) : 0;
            if (sex.equals("M")) {
                this.firstNameSex.put(firstName, count + 1);
            } else if (sex.equals("F")) {
                this.firstNameSex.put(firstName, count - 1);
            }
        }
    }

    public void removeFirstNameSex(String oldFirstName, String oldSex) {
        if (oldFirstName != null && !oldFirstName.isEmpty() && oldSex != null) {
            int count;
            int n = count = this.firstNameSex.containsKey(oldFirstName) ? this.firstNameSex.get(oldFirstName) : 0;
            if (oldSex.equals("M")) {
                this.firstNameSex.put(oldFirstName, count - 1);
            } else if (oldSex.equals("F")) {
                this.firstNameSex.put(oldFirstName, count + 1);
            }
        }
    }

    public String getFirstNameSex(String firstName) {
        int count = 0;
        Integer releveCount = this.firstNameSex.get(firstName);
        if (releveCount != null) {
            count += releveCount.intValue();
        }
        if (count > 0) {
            return "M";
        }
        if (count < 0) {
            return "F";
        }
        return "";
    }

    protected void addGedcomCompletion(Gedcom gedcom) {
        if (gedcom == null) {
            return;
        }
        this.locale = gedcom.getLocale();
        for (Indi indi : gedcom.getIndis()) {
            String firstName = indi.getFirstName().replaceAll(",", "");
            this.firstNames.add(firstName);
            this.addFirstNameSex(firstName, FieldSex.convertValue(indi.getSex()));
        }
        for (String lastName : PropertyName.getLastNames((Gedcom)gedcom, (boolean)false)) {
            this.lastNames.add(lastName);
        }
        for (String occupation : PropertyChoiceValue.getChoices((Gedcom)gedcom, (String)"OCCU", (boolean)false)) {
            this.occupations.add(occupation);
        }
        for (String place : PropertyChoiceValue.getChoices((Gedcom)gedcom, (String)"PLAC", (boolean)false)) {
            this.places.add(place);
        }
    }

    public CompletionSource getFirstNames() {
        return this.firstNames;
    }

    public CompletionSource getLastNames() {
        return this.lastNames;
    }

    public CompletionSource getOccupations() {
        return this.occupations;
    }

    public CompletionSource getNotaries() {
        return this.notaries;
    }

    public CompletionSource getEventTypes() {
        return this.eventTypes;
    }

    public CompletionSource getPlaces() {
        return this.places;
    }

    public void updateFirstName(String firstName, String sex, String oldFirstName, String oldSex) {
        this.firstNames.remove(oldFirstName);
        this.removeFirstNameSex(oldFirstName, oldSex);
        this.firstNames.add(firstName);
        this.addFirstNameSex(firstName, sex);
    }

    public void updateLastName(String value, String oldValue) {
        this.lastNames.remove(oldValue);
        this.lastNames.add(value);
    }

    public void updateOccupation(String value, String oldValue) {
        this.occupations.remove(oldValue);
        this.occupations.add(value);
    }

    public void updateNotary(String value, String oldValue) {
        this.notaries.remove(oldValue);
        this.notaries.add(value);
    }

    public void updatePlaces(String value, String oldValue) {
        this.places.remove(oldValue);
        this.places.add(value);
    }

    public void updateEventType(String value, String oldValue) {
        this.eventTypes.remove(oldValue);
        this.eventTypes.add(value);
    }

    public static List<String> loadExcludeCompletion(CompletionType completionType) {
        String preferenceList;
        ArrayList<String> excludedList = new ArrayList<String>();
        switch (completionType) {
            case firstName: {
                preferenceList = ExcludedFirstNameList;
                break;
            }
            case lastName: {
                preferenceList = ExcludedLastNameList;
                break;
            }
            case occupation: {
                preferenceList = ExcludedOccupationList;
                break;
            }
            case place: {
                preferenceList = ExcludedPlaceList;
                break;
            }
            default: {
                return excludedList;
            }
        }
        String exludedString = NbPreferences.forModule(MainPanelRegister.class).get(preferenceList, "");
        try {
            StringTokenizer tokens = new StringTokenizer(exludedString, ";");
            int n = tokens.countTokens();
            for (int i = 0; i < n; ++i) {
                excludedList.add(tokens.nextToken());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return excludedList;
    }

    public static void saveExcludedCompletion(List<String> excludeList, CompletionType completionType) {
        String preferenceList;
        Object exludedString = "";
        switch (completionType) {
            case firstName: {
                preferenceList = ExcludedFirstNameList;
                break;
            }
            case lastName: {
                preferenceList = ExcludedLastNameList;
                break;
            }
            case occupation: {
                preferenceList = ExcludedOccupationList;
                break;
            }
            case place: {
                preferenceList = ExcludedPlaceList;
                break;
            }
            default: {
                return;
            }
        }
        Iterator<String> it = excludeList.iterator();
        while (it.hasNext()) {
            exludedString = (String)exludedString + it.next().trim() + ";";
        }
        NbPreferences.forModule(MainPanelRegister.class).put(preferenceList, (String)exludedString);
    }

    public void refreshExcludeCompletion(CompletionType completionType) {
        switch (completionType) {
            case firstName: {
                this.firstNames.loadExclude();
                break;
            }
            case lastName: {
                this.lastNames.loadExclude();
                break;
            }
            case occupation: {
                this.occupations.loadExclude();
                break;
            }
            case place: {
                this.places.loadExclude();
                break;
            }
        }
    }

    private class CompletionSet
    implements CompletionSource {
        CompletionType completionType;
        private final Map<String, Integer> key2references = new TreeMap<String, Integer>();
        private final TreeSet<String> excluded = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        private final TreeSet<String> included = new TreeSet(String.CASE_INSENSITIVE_ORDER);

        public CompletionSet(CompletionType completionType) {
            this.completionType = completionType;
            this.loadExclude();
        }

        private void loadExclude() {
            this.setExclude(CompletionProvider.loadExcludeCompletion(this.completionType));
        }

        private boolean add(String key) {
            boolean addedInReference;
            if (key == null || key.equals("")) {
                return false;
            }
            Integer references = this.key2references.get(key);
            if (references == null) {
                references = 1;
                this.key2references.put(key, references);
                if (!this.excluded.contains(key)) {
                    this.included.add(key);
                }
                addedInReference = true;
            } else {
                this.key2references.put(key, references + 1);
                addedInReference = false;
            }
            return addedInReference;
        }

        private boolean remove(String key) {
            boolean removedFromFreference;
            if (key == null || key.equals("")) {
                return false;
            }
            Integer references = this.key2references.get(key);
            if (references == null) {
                return false;
            }
            if (references <= 1) {
                this.key2references.remove(key);
                this.included.remove(key);
                removedFromFreference = true;
            } else {
                this.key2references.put(key, references - 1);
                removedFromFreference = false;
            }
            return removedFromFreference;
        }

        protected void removeAll() {
            this.key2references.clear();
            this.included.clear();
        }

        protected void setExclude(List<String> newExcluded) {
            this.excluded.clear();
            this.excluded.addAll(newExcluded);
            this.included.clear();
            for (String key : this.key2references.keySet()) {
                if (this.excluded.contains(key)) continue;
                this.included.add(key);
            }
        }

        @Override
        public List<String> getAll() {
            return new ArrayList<String>(this.key2references.keySet());
        }

        @Override
        public List<String> getExcluded() {
            return new ArrayList<String>(this.excluded);
        }

        @Override
        public List<String> getIncluded() {
            return new ArrayList<String>(this.included);
        }

        @Override
        public Locale getLocale() {
            return CompletionProvider.this.locale;
        }
    }

    public static enum CompletionType {
        eventType,
        firstName,
        lastName,
        notary,
        occupation,
        place;

    }

    static class SortedList
    extends ArrayList<String> {
        private static final int INSERTIONSORT_THRESHOLD = 7;

        SortedList() {
        }

        public int put(String newElement) {
            int index = this.insert(newElement, 0, this.size());
            return index;
        }

        @Override
        public boolean contains(Object element) {
            return this.indexOfRange(element.toString(), 0, this.size()) >= 0;
        }

        public int indexOfRange(String newElement, int low, int high) {
            int index;
            int lentgh = high - low;
            if (lentgh >= 7) {
                int mid = low + high >>> 1;
                int result = CompareString.compareStringUTF8((String)this.get(mid), newElement);
                return result;
            }
            if (lentgh == 0) {
                return -1;
            }
            for (index = low; index < high; ++index) {
                int result = CompareString.compareStringUTF8((String)this.get(index), newElement);
                if (result < 0) continue;
                if (result > 0) {
                    return index;
                }
                return 0;
            }
            return index;
        }

        private int insert(String newElement, int low, int high) {
            int index;
            int lentgh = high - low;
            if (lentgh >= 7) {
                int mid = low + high >>> 1;
                int result = CompareString.compareStringUTF8((String)this.get(mid), newElement);
                if (result > 0) {
                    return this.insert(newElement, low, mid);
                }
                if (result < 0) {
                    return this.insert(newElement, mid, high);
                }
                return -1;
            }
            if (lentgh == 0) {
                this.add(newElement);
                return 0;
            }
            for (index = low; index < high; ++index) {
                int result = CompareString.compareStringUTF8((String)this.get(index), newElement);
                if (result < 0) continue;
                if (result > 0) {
                    this.add(index, newElement);
                    return index;
                }
                return -1;
            }
            if (index >= this.size()) {
                this.add(newElement);
                return index;
            }
            this.add(index, newElement);
            return index;
        }
    }

    public static interface CompletionSource {
        public List<String> getAll();

        public List<String> getExcluded();

        public List<String> getIncluded();

        public Locale getLocale();
    }
}

