/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.RecordModelAbstract;
import ancestris.modules.releve.model.RecordModelListener;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecordModel
extends RecordModelAbstract {
    protected ArrayList<AbstractRecord> releveList = new ArrayList();
    private boolean dirty = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this.dirty);
    private final ArrayList<RecordModelListener> recordModelListeners = new ArrayList(1);
    private static boolean undoEnabled = true;
    private final Lock lock = new Lock();

    protected int addRecord(final AbstractRecord record) {
        this.releveList.add(record);
        int recordIndex = this.releveList.size() - 1;
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                RecordModel.this.removeRecord(record);
                return null;
            }
        });
        this.fireRecordModelInserted(recordIndex, recordIndex);
        return recordIndex;
    }

    protected void addRecords(List<AbstractRecord> records) {
        for (AbstractRecord record : records) {
            this.releveList.add(record);
        }
        this.fireAllChanged();
    }

    protected void insertRecord(final AbstractRecord record, int recordIndex) {
        this.releveList.add(recordIndex, record);
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                RecordModel.this.removeRecord(record);
                return null;
            }
        });
        this.fireRecordModelInserted(recordIndex, recordIndex);
    }

    protected void swapRecordNext(final AbstractRecord record) {
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                int recordIndex = RecordModel.this.releveList.indexOf(record);
                Collections.swap(RecordModel.this.releveList, recordIndex - 1, recordIndex);
                return record;
            }
        });
        int recordIndex = this.releveList.indexOf(record);
        Collections.swap(this.releveList, recordIndex, recordIndex + 1);
        this.fireRecordModelUpdated(recordIndex, recordIndex + 1);
    }

    protected void swapRecordPrevious(final AbstractRecord record) {
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                int recordIndex = RecordModel.this.releveList.indexOf(record);
                Collections.swap(RecordModel.this.releveList, recordIndex, recordIndex + 1);
                return record;
            }
        });
        int recordIndex = this.releveList.indexOf(record);
        Collections.swap(this.releveList, recordIndex - 1, recordIndex);
        this.fireRecordModelUpdated(recordIndex - 1, recordIndex);
    }

    void renumberRecords(final AbstractRecord record, int[] tableIndexList) {
        final int[] revertTableIndexList = new int[tableIndexList.length];
        for (int i = 0; i < revertTableIndexList.length; ++i) {
            revertTableIndexList[tableIndexList[i]] = i;
        }
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                AbstractRecord[] records = RecordModel.this.releveList.toArray(new AbstractRecord[RecordModel.this.releveList.size()]);
                for (int index : revertTableIndexList) {
                    RecordModel.this.releveList.set(revertTableIndexList[index], records[index]);
                }
                RecordModel.this.fireAllChanged();
                return record;
            }
        });
        AbstractRecord[] records = this.releveList.toArray(new AbstractRecord[this.releveList.size()]);
        for (int index : tableIndexList) {
            this.releveList.set(tableIndexList[index], records[index]);
        }
        this.fireAllChanged();
    }

    protected void removeRecord(final AbstractRecord record) {
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                RecordModel.this.addRecord(record);
                return record;
            }
        });
        int recordIndex = this.releveList.indexOf(record);
        this.releveList.remove(record);
        this.fireRecordModelDeleted(recordIndex, recordIndex);
    }

    protected void removeAll() {
        int previousRowCount = this.releveList.size();
        this.releveList.clear();
        if (previousRowCount > 0) {
            this.fireRecordModelDeleted(0, previousRowCount - 1);
        }
        this.lock.clear();
        this.resetDirty();
    }

    @Override
    public AbstractRecord getRecord(int index) {
        AbstractRecord record;
        try {
            record = this.releveList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            record = null;
        }
        return record;
    }

    public AbstractRecord getPreviousRecord(AbstractRecord record) {
        AbstractRecord previousRecord;
        try {
            previousRecord = this.releveList.get(this.releveList.indexOf(record) - 1);
        }
        catch (IndexOutOfBoundsException e) {
            previousRecord = null;
        }
        return previousRecord;
    }

    public int getIndex(AbstractRecord record) {
        return this.releveList.indexOf(record);
    }

    @Override
    public int getRowCount() {
        return this.releveList.size();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        boolean oldDirty = this.dirty;
        this.dirty = false;
        this.pcs.firePropertyChange("dirty", oldDirty, this.dirty);
    }

    public void addRecordModelListener(RecordModelListener listener) {
        this.recordModelListeners.add(listener);
    }

    public void removeRecordModelListener(RecordModelListener listener) {
        this.recordModelListeners.remove(listener);
    }

    public void fireRecordModelInserted(int firstIndex, int lastIndex) {
        for (RecordModelListener listener : this.recordModelListeners) {
            listener.recordInserted(firstIndex, lastIndex);
        }
    }

    public void fireRecordModelDeleted(int firstIndex, int lastIndex) {
        for (RecordModelListener listener : this.recordModelListeners) {
            listener.recordDeleted(firstIndex, lastIndex);
        }
    }

    public void fireRecordModelUpdated(int firstIndex, int lastIndex) {
        for (RecordModelListener listener : this.recordModelListeners) {
            listener.recordUpdated(firstIndex, lastIndex);
        }
    }

    public void fireRecordModelUpdated(int recordIndex, AbstractRecord.FieldType filedType) {
        for (RecordModelListener listener : this.recordModelListeners) {
            listener.recordUpdated(recordIndex, filedType);
        }
    }

    public void fireAllChanged() {
        for (RecordModelListener listener : this.recordModelListeners) {
            listener.allChanged();
        }
    }

    public String verifyRecord(AbstractRecord record) {
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (record != null) {
                if (record.isEmptyField(AbstractRecord.FieldType.eventDate)) {
                    errorMessage.append("La date de l'\u00e9v\u00e8nement est vide").append("\n");
                }
                if (record.getFieldValue(AbstractRecord.FieldType.indiLastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.indiFirstName).isEmpty()) {
                    errorMessage.append("Le nom et le pr\u00e9nom sont vides").append("\n");
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return errorMessage.toString();
    }

    public AbstractRecord[] findDuplicateRecord(AbstractRecord referenceRecord) {
        ArrayList<AbstractRecord> duplicate = new ArrayList<AbstractRecord>();
        for (AbstractRecord record : this.releveList) {
            if (!record.getFieldValue(AbstractRecord.FieldType.eventDate).equals(referenceRecord.getFieldValue(AbstractRecord.FieldType.eventDate)) || !record.getFieldValue(AbstractRecord.FieldType.indiFirstName).equals(referenceRecord.getFieldValue(AbstractRecord.FieldType.indiFirstName)) || !record.getFieldValue(AbstractRecord.FieldType.indiLastName).equals(referenceRecord.getFieldValue(AbstractRecord.FieldType.indiLastName)) || record == referenceRecord) continue;
            duplicate.add(record);
        }
        return duplicate.toArray(new AbstractRecord[0]);
    }

    public void notiFyFieldChanged(final AbstractRecord record, final AbstractRecord.FieldType fieldType, final Field field, final String oldValue) {
        final int recordIndex = this.getIndex(record);
        this.lock.addChange(new Undo(){

            @Override
            AbstractRecord undo() {
                field.setValue(oldValue);
                RecordModel.this.fireRecordModelUpdated(recordIndex, fieldType);
                return record;
            }
        });
        this.fireRecordModelUpdated(recordIndex, fieldType);
    }

    public static void setUndoEnabled(boolean value) {
        undoEnabled = value;
    }

    public AbstractRecord undo() {
        AbstractRecord record;
        Undo undo = this.lock.removeChange();
        if (undo != null) {
            RecordModel.setUndoEnabled(false);
            record = undo.undo();
            RecordModel.setUndoEnabled(true);
        } else {
            Toolkit.getDefaultToolkit().beep();
            record = null;
        }
        return record;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private class Lock {
        List<Undo> undos = new ArrayList<Undo>();

        private Lock() {
        }

        void clear() {
            this.undos.clear();
        }

        void addChange(Undo run) {
            boolean oldDirty = RecordModel.this.dirty;
            RecordModel.this.dirty = true;
            if (undoEnabled) {
                this.undos.add(run);
                if (this.undos.size() > 1000) {
                    this.undos.remove(0);
                }
            }
            RecordModel.this.pcs.firePropertyChange("dirty", oldDirty, RecordModel.this.dirty);
        }

        Undo removeChange() {
            if (this.undos.size() > 0) {
                return this.undos.remove(this.undos.size() - 1);
            }
            return null;
        }
    }

    private abstract class Undo {
        private Undo() {
        }

        abstract AbstractRecord undo();
    }
}

